#!/bin/bash
#原作者:ccbikai(miantiao.me)

## 备份配置信息 ##

# 备份名称，用于标记
BACKUP_NAME="qiniu"
# 备份目录，多个请空格分隔
BACKUP_SRC="/home/wwwroot/xxx.xxx"
# Mysql主机地址
MYSQL_SERVER="localhost"
# Mysql用户名
MYSQL_USER="root"
# Mysql密码
MYSQL_PASS="mysqlpassword"
# Mysql备份数据库，多个请空格分隔
MYSQL_DBS="dbname"
# 备份文件临时存放目录，一般不需要更改
BACKUP_DIR="/tmp/backuptoqiniu"
# 备份文件压缩密码确保压缩包的安全
BACKUP_FILE_PASSWD="doub.io"

## 备份配置信息 End ##

## 七牛配置信息 ##

#存放空间对应我们在七牛上创建的文件夹
QINIU_BUCKET="doubi"
QINIU_ACCESS_KEY="ACCESS_KEY"
QINIU_SECRET_KEY="SECRET_KEY"

## 七牛配置信息 End ##
## 以下内容都不要修改 ##


## Funs ##
NOW=$(date +"%Y%m%d%H%M%S") #精确到秒，统一秒内上传的文件会被覆盖

mkdir -p $BACKUP_DIR

# 备份Mysql
echo "start dump mysql"
for db_name in $MYSQL_DBS
do
	mysqldump -u $MYSQL_USER -h $MYSQL_SERVER -p$MYSQL_PASS $db_name > "$BACKUP_DIR/$BACKUP_NAME-$db_name.sql"
done
echo "dump ok"

# 打包
echo "start tar"
BACKUP_FILENAME="$BACKUP_NAME-backup-$NOW.zip"
zip -q -r -P $BACKUP_FILE_PASSWD $BACKUP_DIR/$BACKUP_FILENAME $BACKUP_DIR/*.sql $BACKUP_SRC
echo "tar ok"

# 上传
echo "start upload"
python $(dirname $0)/upload.py -a $QINIU_ACCESS_KEY -s $QINIU_SECRET_KEY -b $QINIU_BUCKET -f $BACKUP_DIR/$BACKUP_FILENAME
echo "upload ok"

# 清理备份文件
rm -rf $BACKUP_DIR
echo "backup clean done"
